*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: Terbufos oxon Sulfone                                *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\SAS code Final Models\Diagnostics.SAS";

libname EPA "C:\Users\JNguyen\OneDrive - Environmental Protection Agency (EPA)\Animal studies\50773501-2-3 In Vitro Inhibition Study\from James\kapp data";
/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/


data TerbufosOxonSulfone;
     set epa.toxonsulfone;
run;
proc sort data=TerbufosOxonSulfone;
     by id;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfone - individual sample curves.rtf" startpage=no;
%scatter_plot(chemical=TerbufosOxonSulfone);
ods rtf close;


*===> Human vs. Rat;

title "Human vs. Rat: final model 3";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TerbufosOxonSulfone /**/ tech=newrap lis=3 maxiter=10000;
      PARMS ha=0.9519
			hb=0.2810	
			ra=0.7905
			rb=0.2806	
			gha=0.4436	ghab=.2007		ghb=.1591
			gra=.1796	grab=0.5479	grb=.5133
			S2E=0.4886;

            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-5 + H_I__M + rrb*Rat*1e-5 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha*1e-1, 
												 		 ghab*1e-1, ghb*1e-1,
														 0,    	  0,   gra*1e-1,
														 0,       0,   grab*1e-2, grb*1e-2]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  predict pred out=Resid_HR;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfone human-rat.rtf" startpage=no;
%DiagnosticsHR(chemical=TerbufosOxonSulfone, model=3)
ods rtf close;
%Calculate_Ki(chemical=TerbufosOxonSulfone, Hadj=1e-5, Radj=1e-5);


*===> Adult vs. Infant;



title "final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TerbufosOxonSulfone(where=(Human=1))  tech=nrridg lis=3 maxiter=1000 method=firo;
      PARMS ada=.89	adB=.20
			ia=.81 iB=.27
			gha=.40 	ghab=.21 	ghb=.17
			S2E=0.5150;

			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-5 + H_I__M*adult + rib*1e-5*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-1, ghb*1e-1]) SUBJECT=ID out=RandID_AI; 
	  ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
	  predict pred out=Resid_AI;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfone Adult-Infant.rtf" startpage=no;
%DiagnosticsAI(chemical=TerbufosOxonSulfone, model=2)
ods rtf close;


*===> Male vs. Female;


title "final model 3 - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TerbufosOxonSulfone(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ma=.83	mB=.20
			fa=1.0 fB=.31
			gma=.3299 	gmab=.2425	gmb=.2144
			gfa=.42 	gfab=.10 	gfb=.13
			S2E=.5278;
         	rma=ma+uma;
            rmb=mB+umb;
			rfa=fa+ufa;
			rfb=fB+ufb;
            PRED = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-5 + H_I__M*male + rfb*female*1e-5 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uma umb ufa ufb ~ normal([0, 0, 0, 0],   [gma*1e-1, 
														gmab*1e-1, gmb*1e-1, 
														0,    0,     gfa*1e-1, 
														0,    0,     gfab*1e-1,   gfb*1e-1]) SUBJECT=ID out=RandID_MF; 

	  ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  predict pred out=Resid_MF;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfone Male-Female.rtf" startpage=no;
%DiagnosticsMF(chemical=TerbufosOxonSulfone, model=3)
ods rtf close;



*===> Caucasian vs. Other Races;

title "model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm;
PROC NLMIXED data=TerbufosOxonSulfone(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=.92	cB=.25
			ora=.80 orB=.17
			gha=.40	ghab=1.70	ghb=.15
			S2E=.5161;

            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-5 + H_I__M*caucasian + rorb*otherrace*1e-5 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED, S2E*1e-3);
      RANDOM  uha uhb ~ normal([0, 0],  [gha*1e-1, ghab*1e-2, ghb*1e-1]) SUBJECT=ID out=RandID_CO; 
	  ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasian ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
	  predict pred out=Resid_CO;
run;

ods rtf file="C:\Users\JNguyen\Desktop\OP Inhibition\Diagnostics\TerbufosOxonSulfone Caucasian-Other Races.rtf" startpage=no;
%DiagnosticsCO(chemical=TerbufosOxonSulfone, model=2)
ods rtf close;




